# -*- coding: utf-8 -*-
"""
Created on Thu Mar 18 11:53:20 2021

@author: reinoutubbink
"""

import numpy as np
import matplotlib.pyplot as plt
import glob
import os

#constants needed for plotting
#os.chdir('C:\\Raw_data\\SIM_data\\Results\\Dyn-0.1M\\SIM_BASE10')

currents = []
scanrates = []


for filename in glob.glob('CV*.csv'):
   with open(os.path.join(os.getcwd(), filename), 'r') as f: # open in readonly mode
       curtemp = np.loadtxt(f, delimiter = '\t')
       currents.append(curtemp[:,1])
       scanrate = float(filename[2:-4])/1000
       scanrates.append(scanrate)
       
voltage = curtemp[:,0]
totalV = (max(voltage)-min(voltage))*2

       
Curnum = len(currents)
times = []

for i in range(Curnum):
    time = np.linspace(0,1000*totalV/scanrates[i],len(currents[i]))
    times.append(time)

electrons = []
electronsc = []
totale = 0
for i in range(Curnum):
    injected = []
    injectedc = []
    Sum = 0
    tincr = times[i][10] - times[i][9]
    for j in range(0,len(currents[i])):
        Sum += tincr*-currents[i][j]
        injected.append(Sum)
        injectedc.append(Sum + totale)
    electrons.append(injected)
    electronsc.append(injectedc)
    totale = electronsc[-1][-1]
   
#plt.close('CV comparison')
cmap = plt.get_cmap('Reds')
colors = [cmap(i) for i in np.linspace(0, 1, Curnum+1)]

plt.figure('Total charge in film')
for i in range(Curnum):
    plt.plot(voltage[:len(currents[i])],electrons[i],color=colors[-2-i])


J0 = []
x = np.linspace(scanrates[0],scanrates[-1],Curnum)


plt.figure('CV comparison EXP')
for i in range(Curnum):
    plt.plot(voltage[:len(currents[i])]-0.3,currents[i]*1e3, color=colors[i+1])
    J0.append(-min(currents[i]))
    
    

plt.xlabel('Voltage (V)', size = '15')                              
plt.ylabel('Current density (mA/cm^2)', size = '15')
plt.ylim([-3,2.5])
plt.xlim([-1.35,-0.25])
plt.tick_params(labelsize='25',length=8,width=2)
fig = plt.gcf()
fig.set_size_inches(10, 6, forward=True)
plt.show
  #%%
plt.close("all")
fig1 = plt.figure('scan rate vs maximum current')
ax1 = fig1.add_subplot(1,1,1)
plt.scatter(scanrates[:],J0,color='k', marker='o')
plt.plot(x,x/240,'b--')
plt.plot(x,x**0.5/460,'k--')
plt.yscale('log')
plt.xscale('log')
ax1.set_xlim([0.09,1.2])
ax1.set_ylim([3e-4,5e-3])
ax1.tick_params(length=7, width=2,labelsize='20')
ax1.margins(x=0.01,y=0.1)
fig = plt.gcf()
fig.set_size_inches(5, 3.5, forward=True)
plt.tight_layout()

#RS calculation of the Diffusion coefficient
mobs = []
for i in range(Curnum):
    mobs.append(1.39e-11*(J0[i]/0.1)**2/scanrates[i]*38.68)

figm = plt.figure('Mobilities')    
axm = figm.add_subplot(1,1,1)
plt.scatter(scanrates,mobs,s=100,color='white', marker='o',linewidths=2,edgecolors='k')
plt.xlabel('Scan rate (V/s)', size = '15')                              
plt.ylabel('Mobilities (m2V-1s-1)', size = '15')
plt.yscale('log')
plt.ylim([5e-14,1e-11])
axm.tick_params(which='major',length=8, width=2,labelsize='25')
figm.set_size_inches(10, 7, forward=True)
plt.show()

#%% extraction analysis
extracted = []
for i in range(Curnum):
    half = int(len(currents[i])/2)
    Injection = sum(currents[i][:half])
    Extraction = sum(currents[i][half:])
    extracted.append(-Extraction/Injection*100)
    
#plt.figure('extraction comparison')
#plt.plot(scanrates,extracted)
#plt.xlabel('Scan rate (V/s)', size = '15')                              
#plt.ylabel('extraction (%)', size = '15')